/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.config.value;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.jddev0.ep.config.ConfigValidationException;
import me.jddev0.ep.config.ConfigValue;
import me.jddev0.ep.config.validation.ValueValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FloatConfigValue
extends ConfigValue<Float> {
    private final float minExclusive;
    private final boolean minLenCheckEnabled;
    private final float maxExclusive;
    private final boolean maxLenCheckEnabled;

    public FloatConfigValue(@NotNull String key, @NotNull Float defaultValue) {
        this(key, (String)null, defaultValue);
    }

    public FloatConfigValue(@NotNull String key, @Nullable String comment, @NotNull Float defaultValue) {
        this(key, comment, defaultValue, (ValueValidator<? super Float>)null);
    }

    public FloatConfigValue(@NotNull String key, @Nullable String comment, @NotNull Float defaultValue, @Nullable ValueValidator<? super Float> customValidator) {
        this(key, comment, defaultValue, customValidator, null, null);
    }

    public FloatConfigValue(@NotNull String key, @Nullable String comment, @NotNull Float defaultValue, @Nullable Float minExclusive, @Nullable Float maxExclusive) {
        this(key, comment, defaultValue, null, minExclusive, maxExclusive);
    }

    public FloatConfigValue(@NotNull String key, @Nullable String comment, @NotNull Float defaultValue, @Nullable ValueValidator<? super Float> customValidator, @Nullable Float minExclusive, @Nullable Float maxExclusive) {
        super(key, comment, defaultValue, customValidator);
        this.minLenCheckEnabled = minExclusive != null;
        this.minExclusive = this.minLenCheckEnabled ? minExclusive.floatValue() : 0.0f;
        this.maxLenCheckEnabled = maxExclusive != null;
        this.maxExclusive = this.maxLenCheckEnabled ? maxExclusive.floatValue() : 0.0f;
    }

    @Override
    @NotNull
    public List<String> getValidationCommentLines() {
        ArrayList<String> commentLines = new ArrayList<String>();
        if (this.minLenCheckEnabled) {
            commentLines.add("Value > " + this.minExclusive);
        }
        if (this.maxLenCheckEnabled) {
            commentLines.add("Value < " + this.maxExclusive);
        }
        commentLines.addAll(super.getValidationCommentLines());
        return commentLines;
    }

    @Override
    public void validate(@NotNull Float value) throws ConfigValidationException {
        if (this.minLenCheckEnabled && !(value.floatValue() > this.minExclusive)) {
            throw new ConfigValidationException("The value must be greater than " + this.minExclusive);
        }
        if (this.maxLenCheckEnabled && !(value.floatValue() < this.maxExclusive)) {
            throw new ConfigValidationException("The value must be less than " + this.maxExclusive);
        }
        super.validate(value);
    }

    @Override
    @NotNull
    protected Float readInternal(@NotNull String rawValue) throws ConfigValidationException {
        try {
            return Float.valueOf(Float.parseFloat(rawValue));
        }
        catch (NumberFormatException e) {
            throw new ConfigValidationException("Invalid float value: " + e.getMessage());
        }
    }

    @Override
    @NotNull
    protected String writeInternal(@NotNull Float value) {
        return String.format(Locale.ENGLISH, "%f", value);
    }
}

